require( "scripts/style.lua" );

HeaderFont = {
  standardFont,
  30,
  BlackColor
};


GameModeFont = {
  standardFont,
  30,
  BlackColor
};

TableInfoFont = {
  standardFont,
  30,
  BlackColor
};

EligibleFont = {
  standardFont,
  18,
  BlackColor
};

EligibleAsteriskFont = {
  standardFont,
  12,
  BlackColor
};


ConnectingToServerFont = {
	standardFont,
	18,
	BlackColor
};

TableHeaderFont = {
  standardFont,
  20,
  BlackColor
};

ScoreInfoFont = {
  standardFont,
  18,
  BlackColor
};


ScoreFont = {
  standardFont,
  18,
  BlackColor
};

RankFont = {
  standardFont,
  20,
  BlackColor
};

LeftButtonGraphics = {
	"buttons/arrowleft_up",
	"buttons/arrowleft_down",
	"buttons/arrowleft_over"
};

RightButtonGraphics = {
	"buttons/arrowright_up",
	"buttons/arrowright_down",
	"buttons/arrowright_over"
};

RightCategoryButtonGraphics = {
	"buttons/category_arrowright",
	"buttons/category_arrowright",
	"buttons/category_arrowright"
};

LeftCategoryButtonGraphics = {
	"buttons/category_arrowleft",
	"buttons/category_arrowleft",
	"buttons/category_arrowleft"
};

UpCategoryButtonGraphics = {
	"buttons/category_arrowup",
	"buttons/category_arrowup",
	"buttons/category_arrowup"
};

DownCategoryButtonGraphics = {
	"buttons/category_arrowdown",
	"buttons/category_arrowdown",
	"buttons/category_arrowdown"
};


kScoreRowSpace = 28;
kRowY = 40;
kNumberX = 32;
kNameX = 52;
kScoreX = 355;
kP1X = kNumberX + 1;

kNameW = 250
kNameH = 21

eLocalView=0;
eRequestingCategories=1;
eRequestingScores=2;
eSubmitting=3;
eGlobalView=4;
eError=5;

function UpdateButtons()
	local state = GetState();
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	EnableWindow("view",false);
	EnableWindow("viewlocal",false);
	EnableWindow("submit",false);
	EnableWindow("resubmit",false);
	EnableWindow("categoryleft",false);
	EnableWindow("categoryright",false);

	if (state==eLocalView) then
		local eligibleScore;

		if fullHS then
			EnableWindow("moreinfo",true);
		else 
			EnableWindow("moreinfo",false);
		end

		if not localHS then
			EnableWindow("view",true);

			if (EligibleScoreAvailable()) then
				EnableWindow("submit",true);
			elseif (ScoreAvailable()) then
				EnableWindow("resubmit",true);			
			end
		end
	elseif (state == eGlobalView) then
		EnableWindow("viewlocal",true);
		EnableWindow("categoryleft",true);
		EnableWindow("categoryright",true);
	elseif (state == eError) then
		EnableWindow("viewlocal",true);
	end

end


MakeDialog
{
	-- Name the modal dialog
	name="hiscorescreen",
	Bitmap
	{
		image = "backgrounds/fullscreendialog",
		mask = exists("backgrounds/fullscreendialog.mask.png"),

		THiscore
		{
			x=0,y=0,h=kMax,w=kMax,

			Text
			{
				font = HeaderFont,
				name = "header",
				x=0,y=35,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "highscoreheader"
			};

			Bitmap
			{
				x = kCenter,
				y = 95,
				image = "hiscore/level_name_bg",
				mask = exists("hiscore/level_name_bg.mask.png"),
				Text
				{
					font = GameModeFont,
					name = "gamemode",
					x=0,y=0,w=300,h=40,
					flags = kHAlignCenter + kVAlignCenter,
					label = "#GAMEMODE"
				};
			};

			Bitmap
			{
				x = 110,
				y = 150,
				image = "hiscore/global-hs-bb_large",
				mask = exists("hiscore/global-hs-bb_large.mask.png"),
				name="leftpanel",

				Text
				{
					font = TableHeaderFont,
					name = "local",
					x=0,y=5,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "localhighscores"
				};


				Text
				{
					font = TableHeaderFont,
					name = "global",
					x=0,y=5,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};

				Text
				{
					font = TableHeaderFont,
					name = "topplayers",
					x=0,y=5,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "topplayers"
				};

				Text
				{
					font = ScoreFont,
					name = "1",
					x=0,y=kRowY,w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "1."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_1",
					x=kP1X,y=kRowY
				};

				Text
				{
					font = ScoreFont,
					name = "name1",
					x=kNameX,y=kRowY,w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score1",
					x=0,y=kRowY,w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "2",
					x=0,y=kRowY+(1*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "2."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_2",
					x=kP1X,y=kRowY+(1*kScoreRowSpace)
				};


				Text
				{
					font = ScoreFont,
					name = "name2",
					x=kNameX,y=kRowY+(1*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score2",
					x=0,y=kRowY+(1*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "3",
					x=0,y=kRowY+(2*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "3."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_3",
					x=kP1X,y=kRowY+(2*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name3",
					x=kNameX,y=kRowY+(2*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score3",
					x=0,y=kRowY+(2*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "4",
					x=0,y=kRowY+(3*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "4."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_4",
					x=kP1X,y=kRowY+(3*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name4",
					x=kNameX,y=kRowY+(3*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score4",
					x=0,y=kRowY+(3*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "5",
					x=0,y=kRowY+(4*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "5."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_5",
					x=kP1X,y=kRowY+(4*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name5",
					x=kNameX,y=kRowY+(4*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score5",
					x=0,y=kRowY+(4*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "6",
					x=0,y=kRowY+(5*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "6."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_6",
					x=kP1X,y=kRowY+(5*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name6",
					x=kNameX,y=kRowY+(5*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score6",
					x=0,y=kRowY+(5*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "7",
					x=0,y=kRowY+(6*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "7."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_7",
					x=kP1X,y=kRowY+(6*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name7",
					x=kNameX,y=kRowY+(6*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score7",
					x=0,y=kRowY+(6*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "8",
					x=0,y=kRowY+(7*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "8."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_8",
					x=kP1X,y=kRowY+(7*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name8",
					x=kNameX,y=kRowY+(7*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score8",
					x=0,y=kRowY+(7*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "9",
					x=0,y=kRowY+(8*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "9."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_9",
					x=kP1X,y=kRowY+(8*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name9",
					x=kNameX,y=kRowY+(8*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score9",
					x=0,y=kRowY+(8*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "10",
					x=0,y=kRowY+(9*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "10."
				};

				Bitmap
				{
					image = "hiscore/p1icon",
					mask = exists("hiscore/p1icon.mask.png"),
					name = "p1_10",
					x=kP1X,y=kRowY+(9*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name10",
					x=kNameX,y=kRowY+(9*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score10",
					x=0,y=kRowY+(9*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

			};

			Bitmap
			{
				x = 535,
				y = 150,
				image = "hiscore/local-hs-bb",
				mask = exists("hiscore/local-hs-bb.mask.png"),
				name="rightpanelsmall",

				Text
				{
					font = ScoreInfoFont,
					name = "yourrankglobalinfo",
					x=10,y=110,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignCenter,
					label = "globalhighscoreinfo"
				};

				Text
				{
					font = RankFont,
					name = "yourrank",
					x=10,y=20,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "yourrank"
				};

				Text
				{
					font = RankFont,
					name = "congratulations",
					x=10,y=100,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "congratshighscore"
				};

				Text
				{
					font = RankFont,
					name = "dnq",
					x=10,y=100,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scorednq"
				};
			},


			Bitmap
			{
				x = 535,
				y = 150,
				image = "hiscore/local-hs-bb",
				mask = exists("hiscore/local-hs-bb.mask.png"),
				name="rightpanel",

				Text
				{
					font = TableHeaderFont,
					name = "globalinfoheader",
					x=30,y=15,w=kMax-30,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};

				Text
				{
					font = ScoreInfoFont,
					name = "info",
					x=10,y=80,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscoreinfo"
				};


				Text
				{
					font = EligibleFont,
					name = "eligible",
					x=10,y=220,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "eligible"
				};

				SetStyle(ThinButtonStyle),
				Button
				{
					x=kCenter,
					y=kMax-30,
					name="moreinfo",
					label="moreinfo",
					command =
						function()
							DoModal("scripts/hiscoreinfo.lua");
						end

				};

				Button
				{
					x=kCenter,
					y=kMax-60,
					name="submit",
					label="submit",
					command =
						function()
							vars = loadstring(GetLuaServerSubmitSetupVars(false));
							vars();
							val = DoModal("scripts/serversubmit.lua");
							if (val == 'qualified')	 then
								SubmissionDone(true);
							elseif (val == 'success') then
								SubmissionDone(false);
							else
								-- nothing
							end
						end
				};
				
				Button
				{
					x=kCenter,
					y=kMax-60,
					name="resubmit",
					label="resubmit",
					command =
						function()
							vars = loadstring(GetLuaServerSubmitSetupVars(false));
							vars();
							val = DoModal("scripts/serversubmit.lua");
							if (val == 'qualified')	 then
								SubmissionDone(true);
							elseif (val == 'success') then
								SubmissionDone(false);
							else
								-- nothing
							end
						end
				};
			};

			Text
			{
				font = ConnectingToServerFont,
				name = "server",
				x=535,y=300,w=150,h=130,
				flags = kHAlignCenter + kVAlignCenter,
				label = "connectingtoserver"
			};

			Text
			{
				font = ConnectingToServerFont,
				name = "error",
				x=535,y=300,w=150,h=130,
				flags = kHAlignCenter + kVAlignCenter,
			};

			Text
			{
				font = ScoreFont,
				name = "category",
				x=200,y=470,w=208,h=40,
				flags = kHAlignCenter + kVAlignTop,
			};

			SetStyle(ThinButtonStyle),

			Button
			{
				label="",
				graphics = LeftButtonGraphics,
				name="gamemodeleft",
				x=160,
				y=90,
			};

			Button
			{
				label="",
				graphics = RightButtonGraphics,
				name="gamemoderight",
				x=570,
				y=90,
			};
			
			Button
			{
				label="",
				graphics = LeftCategoryButtonGraphics,
				name="categoryleft",
				x=190,
				y=472,
			};

			Button
			{
				label="",
				graphics = RightCategoryButtonGraphics,
				name="categoryright",
				x=390,
				y=472,
			};

			Button
			{
				label="",
				graphics = UpCategoryButtonGraphics,
				name="scrollup",
				x=480,
				y=195,
			};

			Button
			{
				label="",
				graphics = DownCategoryButtonGraphics,
				name="scrolldown",
				x=480,
				y=430,
			};

			Button
			{
				x=130,
				y=kMax-85,
				name="back",
				type = kPush,
				flags = kHAlignCenter + kVAlignCenter,
				label="back",
				command =
					function()
						PopModal("hiscorescreen"); -- take off high score menu, restart game loop
					end
			};

            SetStyle(LongBlueButtonStyle),
			Button
			{
				align=kHAlignRight, -- Position this button at its right edge
				x=720,				-- With above align, position the right edge
				y=kMax-86,
				name="viewlocal",
				label="viewlocal",
				scale=1.1
			};
			Button
			{
				align=kHAlignRight, -- Position this button at its right edge
				x=710,				-- With above align, position the right edge
				y=kMax-86,
				name="view",
				label="viewglobal",
				scale=1.1
			};


		}
	}
}